<?php
// -- Include the required data and requirements for this page
include("templates/headers/inc.php");

// Include the JS file
$js_files = array("js/pages/admin.js");

// Metadata informations of this page
$page_title = "Admin";
$page_slug	= "admin";

// Get website config
$site_config = $dbh->prepare("SELECT * FROM config WHERE config_name IN ('website_name','website_tagline')");
$site_config->execute();

$config_array = array();

while($config = $site_config->fetch(PDO::FETCH_ASSOC)) {
	$config_array[$config["config_name"]] = $config["config_value"];
}

$website_name = $config_array["website_name"];
$website_tagline = $config_array["website_tagline"];

// -- General checks and redirects
// If we have a session, redirect !
if(!$_SESSION || !isset($_SESSION["USER_ID"])) {
	header("Location: index.php?action=need_log_in");
	exit;
}

if($_SESSION["RANK"] == 0) {
	header("Location: home.php?action=forbidden");
	exit;	
}

$user_id = $_SESSION["USER_ID"];

// Check if user exists...
$total_quiz = $dbh->prepare("	SELECT *
								FROM quiz
								");
					
$total_quiz->execute();

	
// -- Include the header template
include("templates/headers/admin_header.php")
?>

<div class="row">
	
	<div class="inner-container">	
		<div class="quiz_list_container">
			<div class="row row-stats">
				<div class="col-md-6">
					<h4><?php echo $total_quiz->rowCount(); ?> Total Quiz</h4>
				</div>
			</div>
			<?php
			if($total_quiz->rowCount() == 0) {
			?>
			<div class="alert alert-danger alert-center">
				No quiz were published for the moment <i class="em em-anguished"></i>
			</div>
			<?php
			} else {
			?>
			<table class="table table-striped table-quizzes">
				<tr>
					<th>Quiz</th>
					<th>Participants</th>
					<th>Actions</th>
				</tr>
				<?php
				// Pagination
				$perpage = 15;
				$posts  = $total_quiz->rowCount();
				$pages  = ceil($posts / $perpage);
				
				$get_pages = isset($_GET['page']) ? $_GET['page'] : 1;
				
				$data = array(
	
					'options' => array(
						'default'   => 1,
						'min_range' => 1,
						'max_range' => $pages
						)
				);
		
				$number = trim($get_pages);
				$number = filter_var($number, FILTER_VALIDATE_INT, $data);
				$range  = $perpage * ($number - 1);
		
				$prev = $number - 1;
				$next = $number + 1;
					
				// Get list of all quiz
				$quiz_query = $dbh->prepare("SELECT * FROM quiz ORDER BY created_at DESC LIMIT :limit, :perpage");
				$quiz_query->bindParam(':perpage', $perpage, PDO::PARAM_INT);
				$quiz_query->bindParam(':limit', $range, PDO::PARAM_INT);
				$quiz_query->execute();
					
				while($quiz = $quiz_query->fetch(PDO::FETCH_ASSOC)) {
					
					$cur_quiz_id = $quiz["id"];
					
					// Count the number of participatings on this quiz
					$nb_part_query = $dbh->prepare("SELECT id FROM participation WHERE quiz_id = :quiz_id");
					$nb_part_query->bindParam(":quiz_id", $cur_quiz_id);
					$nb_part_query->execute();
					
					$nb_parts = $nb_part_query->rowCount();
				?>
				<tr class="quiz-line" data-id="<?php echo $quiz["unique_id"]; ?>">
					<td class="align-left">
						<span class="q-title"><?php echo ucfirst($quiz["title"]); ?></span>
						<br />
						<a class="btn btn-primary btn-sm btn-copy-link" data-clipboard-text="<?php echo URL ?>/quiz.php?id=<?php echo $quiz["unique_id"]; ?>"><i class="fas fa-copy"></i> Copy Quiz Link</a>
					</td>
					<?php
					if($nb_parts > 0) {
					?>
					<td>
						<?php echo $nb_parts; ?>
					</td>
					<?php
					} else {
					?>
					<td><?php echo $nb_parts; ?></td>
					<?php
					}
					?>
					<td><a href="" class="btn btn-danger btn-delete btn-home-delete btn-sm" data-id="<?php echo $quiz["unique_id"]; ?>"><i class="fas fa-times"></i></a></td>
				</tr>
				<?php
				}	
				?>
			</table>
			<?php
			if($posts > 0) {
				if($pages > 1) {	
				?>
				<div class="pagination">
				<?php	
					echo "<div class='page-list'>";
	
					# first page
					if($number <= 1)
						echo "<span>&laquo; prev</span> | <a href=\"?page=$next\">next &raquo;</a>";
					
					# last page
					else if($number >= $pages)
						echo "<a href=\"?page=$prev\">&laquo; prev</a> | <span>next &raquo;</span>";
					
					# in range
					else
						echo "<a href=\"?page=$prev\">&laquo; prev</a> | <a href=\"?page=$next\">next &raquo;</a>";
	
					echo "</div>";
				?>
				</div>
				<?php
				}
			}	
			?>
			<?php
			}
			?>
		</div>
	</div>
					
</div>

<?php
// -- Include the footer template
include("templates/footers/global_footer.php");	
?>